<?php
/* --------------------------------------------------------------
   HorizontalPosition.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects;

use Webmozart\Assert\Assert;

class HorizontalPosition
{
    /**
     * @var int
     */
    private $value;
    
    
    /**
     * Constructor.
     */
    private function __construct(int $value)
    {
        Assert::greaterThanEq($value, 0);
        
        $this->value = $value;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(int $horizontalPosition): self
    {
        return new self($horizontalPosition);
    }
    
    
    /**
     * Return value.
     */
    public function value(): int
    {
        return $this->value;
    }
}